// import fetch from '@/utils/fetch';
// import { getBaseUrl } from '@/utils/index'
// import { setCookie, getCookie, delCookie } from '@/utils/index';
// import { envConfig } from '@/utils/env-config';
import { findQuestionIndexNo } from "@/utils";

const question = {
  state: {
    currentTitle: "题库",
    questionList: [],
    currentQuestion: {
      isAnalyzed: false,
      options: [         // 从options加工出来
        {
          isCorrect: false,
          isSelected: true,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
        {
          isCorrect: true,
          isSelected: true,
          text: "进行分析评估",
        },
        {
          isCorrect: false,
          isSelected: false,
          text: "进行分析评估",
        },
      ],
      titleId: 1,
      titleNo: 1,           // 题序，从1开始
      typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
      unionId: "",          // 联合类型题目，分组唯一标识
      unionType: 1,         // 0普通题型 1-共用题干； 2-共用选项
      unionQuestion: "",    // 共用题干
      question: '题干内容<img src="https://files.yunqueyi.com/image/png/protal/project/20200702161856970.png" />',   // 题干内容
      config: "",           // 选项
      answer: "",           // 正确答案
      intro: "",            // 题目解析
      score: 0,             // 题目分值
      myAnswer: "",         // 我的答案
      commitFlag: 0,        // 0还未做 1做对了 2做错了
      favorFlag: 0,         // 0未收藏 1已收藏
      pictureFlag: "",      // 0没有图 1有图
      questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
      directoryId: 0,       // 题库ID
      paperId: "",          // 试卷ID
      paperIndex: "",       // 试卷索引
    },
    commonConfig: {
      // 0: 免费; 1: 收费;  没有绑卡且是收费题库（bindStatus == 0 && freeFlag == 1）可以走免费体验流程   
      freeFlag: 0,              
      directoryId: "",
      secondSubjectId: 0,
      cardType: 3,
      goodsType: 3,
      commitKind: 1,            // 答题来源 1：错题集 2：收藏 3：题库
    },
    titleConfig: {
      bindStatus: 0,            // 绑卡状态：0未绑卡 1已绑卡
      commitKind: 1,            // 答题来源 1：错题集 2：收藏 3：题库
      currentTitleNo: 0,        // 定位答题题目id
      resultId: 0,              // 刷题库轮次ID
      totalCount: 0,            // 题目总数
    }
  },
  mutations: {
    SET_COMMON_CONIFG: (state, payload) => {
      state.commonConfig = payload;
    },
    SET_TITLE_CONIFG: (state, payload) => {
      state.titleConfig = payload;
    },
    SET_COMMIT_KIND: (state, payload) => {
      state.titleConfig.commitKind = payload;
    },
    SET_FREE_FLAG: (state, payload) => {
      state.titleConfig.freeFlag = payload;
    },
    SET_TOTAL_COUNT: (state, payload) => {
      state.titleConfig.totalCount = payload;
    },
    SET_QUESTION_LIST: (state, payload) => {
      state.questionList = payload;
    },
    SET_CURRENT_QUESTION: (state, payload) => {
      state.currentQuestion = payload;
    },
  },
  actions: {
    // 获取用户信息
    // async getQuestionList({ commit, state }, params) {
    //   // let param = {
    //   //   ...params,
    //   //   token: '998E10CD98ED4BCF91A28223270FE8CE',
    //   //   setEntry: true
    //   // };
    //   // this.GET(`portal/titleTest/practise/titles`, param).then(({ data }) => {
    //   //   console.log(data);
    //   // });

    //   // getQuestionList
    //   console.log(params);
    //   let currentList = [
    //     {
    //       isAnalyzed: false,
    //       options: [
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估",
    //         },
    //         {
    //           isCorrect: true,
    //           isSelected: false,
    //           text: "进行分析评估",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估",
    //         },
    //       ],
    //       titleId: 1,
    //       titleNo: 1,           // 题序，从1开始
    //       typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
    //       unionId: "",          // 联合类型题目，分组唯一标识
    //       unionType: 0,         // 0普通题型 1-共用题干； 2-共用选项
    //       unionQuestion: "",    // 共用题干
    //       question: "题干内容",   // 题干内容
    //       config: "",           // 选项
    //       answer: "",           // 正确答案
    //       intro: "",            // 题目解析
    //       score: 0,             // 题目分值
    //       myAnswer: "",         // 我的答案
    //       commitFlag: 0,        // 0还未做 1做对了 2做错了
    //       favorFlag: 0,         // 0未收藏 1已收藏
    //       pictureFlag: "",      // 0没有图 1有图
    //       questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
    //       directoryId: 0,       // 题库ID
    //       paperId: "",          // 试卷ID
    //       paperIndex: "",       // 试卷索引
    //     },
    //     {
    //       isAnalyzed: false,
    //       options: [
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估2",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估2",
    //         },
    //         {
    //           isCorrect: true,
    //           isSelected: false,
    //           text: "进行分析评估2",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评3",
    //         },
    //       ],
    //       titleId: 2,
    //       titleNo: 2,           // 题序，从1开始
    //       typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
    //       unionId: "",          // 联合类型题目，分组唯一标识
    //       unionType: 2,         // 0普通题型 1-共用题干； 2-共用选项
    //       unionQuestion: "",    // 共用题干
    //       question: "题干内容",   // 题干内容
    //       config: "",           // 选项
    //       answer: "",           // 正确答案
    //       intro: "",            // 题目解析
    //       score: 0,             // 题目分值
    //       myAnswer: "",         // 我的答案
    //       commitFlag: 0,        // 0还未做 1做对了 2做错了
    //       favorFlag: 0,         // 0未收藏 1已收藏
    //       pictureFlag: "",      // 0没有图 1有图
    //       questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
    //       directoryId: 0,       // 题库ID
    //       paperId: "",          // 试卷ID
    //       paperIndex: "",       // 试卷索引
    //     },
    //     {
    //       isAnalyzed: false,
    //       options: [
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估3",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估3",
    //         },
    //         {
    //           isCorrect: true,
    //           isSelected: false,
    //           text: "进行分析评估3",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估3",
    //         },
    //       ],
    //       titleId: 3,           // 
    //       titleNo: 3,           // 题序，从1开始
    //       typeId: 1,            // 题目类型ID 1-单选，2-多选，3-判断
    //       unionId: "",          // 联合类型题目，分组唯一标识
    //       unionType: 1,         // 0普通题型 1-共用题干； 2-共用选项
    //       unionQuestion: "",    // 共用题干
    //       question: "题干内容",   // 题干内容
    //       config: "",           // 选项
    //       answer: "",           // 正确答案
    //       intro: "",            // 题目解析
    //       score: 0,             // 题目分值
    //       myAnswer: "",         // 我的答案
    //       commitFlag: 0,        // 0还未做 1做对了 2做错了
    //       favorFlag: 0,         // 0未收藏 1已收藏
    //       pictureFlag: "",      // 0没有图 1有图
    //       questionStreamType: "", // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
    //       directoryId: 0,       // 题库ID
    //       paperId: "",          // 试卷ID
    //       paperIndex: "",       // 试卷索引
    //     },
    //     {
    //       isAnalyzed: false,
    //       options: [
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估4",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估4",
    //         },
    //         {
    //           isCorrect: true,
    //           isSelected: false,
    //           text: "进行分析评估4",
    //         },
    //         {
    //           isCorrect: false,
    //           isSelected: false,
    //           text: "进行分析评估4",
    //         },
    //       ],
    //       titleId: 4,
    //       titleNo: 4,           // 题序，从1开始
    //       typeId: 2,            // 题目类型ID 1-单选，2-多选，3-判断
    //       unionId: "",          // 联合类型题目，分组唯一标识
    //       unionType: 1,         // 0普通题型 1-共用题干； 2-共用选项
    //       unionQuestion: "",    // 共用题干
    //       question: "题干内容",  // 题干内容
    //       config: "",           // 选项
    //       answer: "",           // 正确答案
    //       intro: "",            // 题目解析
    //       score: 0,             // 题目分值
    //       myAnswer: "",         // 我的答案
    //       commitFlag: 0,        // 0还未做 1做对了 2做错了
    //       favorFlag: 0,         // 0未收藏 1已收藏
    //       pictureFlag: "",      // 0没有图 1有图
    //       questionStreamType: "",   // 题干内流媒体类型：0-文本，1-图片，2-视频，3-音频
    //       directoryId: 0,       // 题库ID
    //       paperId: "",          // 试卷ID
    //       paperIndex: "",       // 试卷索引
    //     },
    //   ];
    //   commit('SET_QUESTION_LIST', currentList);
    //   // commit('SET_CURRENT_QUESTION', currentList[0] || {options:[]});
    //   commit('SET_TOTAL_COUNT', 30);
    // },

    // needFecth() {
    //   let qIndex = this.questionList.findIndex( (item, index) => {
        
    //   })
    // },

    // 处理数据
    getQuestionList({ commit, state }, questionList) {
      // debugger
      let handlerList = [], question, option, optionList = [], myAnswer = "", answer = "";
      questionList.forEach( (item, index) => {
        question = JSON.parse(JSON.stringify(item));
        question.isAnalyzed = false;
        option = {};
        optionList = [];
        question.options.forEach( (text, i) => {
          option.isCorrect = false;
          option.isSelected = false;
          option.text = text;
          optionList.push(JSON.parse(JSON.stringify(option)));
        });
        question.options = optionList;
        console.log('handlerList', index);
        handlerList.push(question);
      });
      console.log('in handlerList', handlerList);
      let cIndex = findQuestionIndexNo(handlerList, 'titleNo', this.currentTitleNo);
      this.$store.commit("SET_CURRENT_QUESTION", handlerList[cIndex]);
      this.$store.commit("SET_QUESTION_LIST", handlerList);
    },

  },
}

export default question;
